package top.doudou.base.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * @program:
 * @description 浏览器工具类
 * @author: 傻男人<244191347@qq.com>
 * @create: 2019-04-24 11:25
 **/
@Slf4j
public class BrowserUtil extends WebUtils {

    /**
     * 检查是否为浏览器
     * @param request
     * @return
     */
    public static boolean isBrowser(HttpServletRequest request){
        String userAgent = request.getHeader("User-Agent");
        if(StringUtils.isNotBlank(userAgent) && userAgent.startsWith("Mozilla/5.0")){
            return true;
        }
        String accept = request.getHeader("Accept");
        if(StringUtils.isNotBlank(accept) && accept.startsWith("text/html")){
            return true;
        }
        return false;
    }

}
