package top.doudou.base.util;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @Description 工具类
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-11-15 14:18
 */
@Slf4j
public class HttpServletUtil {

    /**
     * 获取HttpServletRequest对象
     */
    public static HttpServletRequest getRequest() {
        ServletRequestAttributes attributes = getAttributes();
        return attributes != null ? attributes.getRequest() : null;
    }

    /**
     * 获取HttpServletResponse对象
     */
    public static HttpServletResponse getResponse() {
        ServletRequestAttributes attributes = getAttributes();
        return attributes != null ? attributes.getResponse() : null;
    }

    /**
     * 获取ServletRequestAttributes对象
     */
    public static ServletRequestAttributes getAttributes() {
        return (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
    }
}
