package top.doudou.base.util.verify;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.awt.*;
import java.io.Serializable;


/**
 * @Description 验证码属性
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-21 15:40
 * @Version V1.0
 */
@Data
public class ImageCodeProperty implements Serializable {

    private static final long serialVersionUID = 7030267500882775069L;

    @ApiModelProperty(" 图片宽度(注意此宽度若过小,容易造成验证码文本显示不全,如4个字符的文本可使用85到90的宽度)")
    private int width;

    @ApiModelProperty("图片高度")
    private int height;

    @ApiModelProperty("图片中干扰线的条数")
    private int interLine;

    @ApiModelProperty("每个字符的高低位置是否随机")
    private boolean randomLocation;

    @ApiModelProperty("若为null则表示采用随机颜色")
    private Color backColor;

    @ApiModelProperty("若为null则表示采用随机颜色")
    private Color foreColor;

    @ApiModelProperty("若为null则表示采用随机颜色")
    private Color lineColor;

    public ImageCodeProperty(){
        this.width = 120;
        this.height = 40;
        this.randomLocation = true;
        this.interLine = 4;
    }

    public ImageCodeProperty(int width,int height,int interLine){
        this.width = width;
        this.height = height;
        this.randomLocation = true;
        this.interLine = interLine;
    }

    public ImageCodeProperty(int width,int height,int interLine,boolean randomLocation){
        this.width = width;
        this.height = height;
        this.randomLocation = randomLocation;
        this.interLine = interLine;
    }

    public ImageCodeProperty(int width,int height,int interLine,boolean randomLocation,Color backColor,Color foreColor,Color lineColor){
        this.width = width;
        this.height = height;
        this.randomLocation = randomLocation;
        this.interLine = interLine;
        this.backColor = backColor;
        this.foreColor = foreColor;
        this.lineColor = lineColor;
    }
}
