package top.doudou.base.valid;


import top.doudou.base.context.ApplicationContextUtils;
import top.doudou.base.valid.annotation.CustomValid;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @Description 校验约束对象
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2021-10-08 11:30
 * @Version V1.0
 */
public class CustomValidConstraint implements ConstraintValidator<CustomValid, Object> {

    private CustomValid customValid;

    @Override
    public void initialize(CustomValid customValid) {
        this.customValid = customValid;
    }

    @Override
    public boolean isValid(Object obj, ConstraintValidatorContext constraintValidatorContext) {
        ValidHandler validHandler = ApplicationContextUtils.getBean(customValid.handler());
        return validHandler.handler(customValid, obj);
    }
}
