package top.doudou.base.valid.annotation;


import top.doudou.base.valid.CustomValidConstraint;
import top.doudou.base.valid.ValidHandler;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @Description 自定义的入参校验注解
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2021-10-08 11:25
 * @Version V1.0
 */
@Target({ElementType.TYPE, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = CustomValidConstraint.class)
public @interface CustomValid {

    String message() default "校验失败";

    Class<?>[] groups() default { };

    Class<? extends Payload>[] payload() default { };

    /**
     * 指定校验的实际处理器
     * @return
     */
    Class<? extends ValidHandler> handler();
}
