package top.doudou.base.valid.code;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Description 验证码
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-28 10:28
 */
@Data
public class ValidateCode implements Serializable {

    @ApiModelProperty("验证码")
    private String code;

    @ApiModelProperty("过期时间")
    private LocalDateTime expireTime;

    public ValidateCode(String code, int expireIn){
        this.code = code;
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
    }

    public ValidateCode(String code, LocalDateTime expireTime){
        this.code = code;
        this.expireTime = expireTime;
    }

    public boolean isExpried() {
        return LocalDateTime.now().isAfter(expireTime);
    }

}
