/**
 * 
 */
package top.doudou.base.valid.code.config;

import org.springframework.web.context.request.ServletWebRequest;

/**
 * @Description 校验码处理器，封装不同校验码的处理逻辑
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-28 10:28
 */
public interface ValidateCodeProcessor {

	/**
	 * 验证码放入session时的前缀
	 */
	String SESSION_KEY_PREFIX = "SESSION_KEY_FOR_CODE_";

	/**
	 * 创建校验码
	 * 
	 * @param request
	 * @throws Exception
	 */
	void create(ServletWebRequest request) throws Exception;

	/**
	 * 校验验证码
	 * 
	 * @param servletWebRequest
	 * @throws Exception
	 */
	void validate(ServletWebRequest servletWebRequest);

}
