package top.doudou.base.valid.code.image;

import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletWebRequest;
import top.doudou.base.valid.code.impl.AbstractValidateCodeProcessor;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;

/**
 * @Description  图片验证码处理器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-28 10:28
 */
@Component("imageValidateCodeProcessor")
public class ImageCodeProcessor extends AbstractValidateCodeProcessor<ImageCode> {

	/**
     * 发送图形验证码，将其写到响应中
	 */
	@Override
	protected void send(ServletWebRequest request, ImageCode imageCode) throws Exception {
		HttpServletResponse response = request.getResponse();
		request.getResponse().setContentType("image/jpeg");
		ImageIO.write(imageCode.getImage(), "JPEG", response.getOutputStream());
	}

}