package top.doudou.base.valid.code.sms;

import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.doudou.base.constant.SysConstant;
import top.doudou.base.properties.ValidateCodeProperties;
import top.doudou.base.valid.code.ValidateCode;
import top.doudou.base.valid.code.ValidateCodeGenerator;

/**
 * @Description
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-28 10:28
 */
@Component("smsValidateCodeGenerator")
public class SmsCodeGenerator implements ValidateCodeGenerator {

    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    /**
     * 生成验证码
     *
     * @param request
     * @return
     */
    @Override
    public ValidateCode generate(ServletWebRequest request) {
        String code = RandomStringUtils.randomNumeric(validateCodeProperties.getSms().getLength());
        return new ValidateCode(code, ServletRequestUtils.getIntParameter(request.getRequest(), SysConstant.EXPIRE_IN, validateCodeProperties.getImage().getExpireIn()));
    }
}
