package top.doudou.base.valid.code.sms;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.doudou.base.constant.SysConstant;
import top.doudou.base.valid.code.ValidateCode;
import top.doudou.base.valid.code.impl.AbstractValidateCodeProcessor;

/**
 * @Description 短信验证码处理器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-28 10:28
 */
@Component("smsValidateCodeProcessor")
public class SmsCodeProcessor extends AbstractValidateCodeProcessor<ValidateCode> {

	/**
     * 短信验证码发送器
	 */
	@Autowired
	private SmsCodeSender smsCodeSender;

	
	@Override
	protected void send(ServletWebRequest request, ValidateCode validateCode) throws Exception {
		String paramName = SysConstant.DEFAULT_PARAMETER_NAME_MOBILE;
		String mobile = ServletRequestUtils.getRequiredStringParameter(request.getRequest(), paramName);
		smsCodeSender.send(mobile, validateCode.getCode());
	}

}