package top.doudou.base.web;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import top.doudou.core.builder.JsonBuilder;
import top.doudou.core.exception.ExceptionUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2021-02-08 11:36
 * @Version V1.0
 */
@Slf4j
public class ResponseUtil {

    public static void write(HttpServletResponse response,Object result){
        write(response,HttpStatus.OK,result);
    }

    public static void write(HttpServletResponse response, HttpStatus status,Object result){
        if(null == response){
            return;
        }
        if(null == status){
            status = HttpStatus.OK;
        }
        if(null == result){
            result = "";
        }
        try{
            response.setStatus(status.value());
            response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_VALUE);
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(JsonBuilder.gson().toJson(result));
            response.getWriter().flush();
        }catch (IOException e) {
            log.error(ExceptionUtils.toString(e));
        }
    }
}
