package top.doudou.base.web;


import org.springframework.web.context.request.ServletWebRequest;
import top.doudou.core.util.FastAssert;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author: 傻男人
 * @Date: 2021-10-29 10:01
 * @Version: 1.0
 * @Description: Session 工具类
 */
public class SessionUtils {

    /**
     * 设置session的值
     * @param request
     * @param key
     * @param value
     */
    public static void setAttr(HttpServletRequest request, String key, Object value){
        FastAssert.notNull(request,"request is null");
        request.getSession(true).setAttribute(key, value);
    }

    public static void setAttr(ServletWebRequest request, String key, Object value){
        FastAssert.notNull(request,"request is null");
        setAttr(request.getRequest(),key,value);
    }

    /**
     * 获取session的值
     * @param request
     * @param key
     */
    public static Object getAttr(HttpServletRequest request,String key){
        FastAssert.notNull(request,"request is null");
        return request.getSession(true).getAttribute(key);
    }

    public static Object getAttr(ServletWebRequest request,String key){
        FastAssert.notNull(request,"request is null");
        return getAttr(request.getRequest(),key);
    }
 
    /**
     * 删除Session值
     * @param request
     * @param key
     */
    public static void removeAttr(HttpServletRequest request,String key){
        FastAssert.notNull(request,"request is null");
        request.getSession(true).removeAttribute(key);
    }

    public static void removeAttr(ServletWebRequest request,String key){
        FastAssert.notNull(request,"request is null");
        removeAttr(request.getRequest(),key);
    }
}
