package top.doudou.base.web.filter;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;

/**
 * @Description 默认的跨域请求配置
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-28 16:02
 * @Version V1.0
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE)
public class DefaultCrossFilter extends OncePerRequestFilter {

    private static final String ALL = "x-requested-with, authorization, Content-Type, Authorization, credential, X-XSRF-TOKEN,token,username,client";

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String referer = request.getHeader("origin");
        if (StringUtils.isNotBlank(referer)) {
            URL url = new URL(referer);
            String origin = url.getProtocol() + "://" + url.getHost();
            if(url.getPort()!=-1){
                origin+=":"+url.getPort();
            }
            response.addHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            response.addHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        } else {
            response.addHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        }
        response.setHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, "POST, GET, OPTIONS, DELETE,PUT,HEAD");
        response.setHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, ALL);
        response.setHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS,
                "Accept,x-requested-with,Origin, authorization, Content-Type, Authorization");
        //预检方法为option
        if (request.getMethod().equals(HttpMethod.OPTIONS))
            response.setStatus(HttpServletResponse.SC_OK);
        else
            chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }

}