package top.doudou.base.web.filter;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-26 11:39
 * @Version V1.0
 */
@Slf4j
@Configuration
public class FilterConfig {

    @Bean
    @ConditionalOnProperty(name = "filter.cross.enabled",havingValue = "true",matchIfMissing = false)
    public DefaultCrossFilter corsFilter() {
        return new DefaultCrossFilter();
    }

    @Bean
    @Order(Ordered.HIGHEST_PRECEDENCE)
    @ConditionalOnProperty(name = "filter.cross.enabled",havingValue = "true",matchIfMissing = false)
    public FilterRegistrationBean crossFilterRegistrationBean(){
        log.info("--------注册跨域过滤器----------");
        FilterRegistrationBean frb = new FilterRegistrationBean();
        frb.setOrder(Ordered.HIGHEST_PRECEDENCE);
        frb.setFilter(corsFilter());
        frb.addUrlPatterns("/*");
        frb.setName("crossFilter");
        return frb;
    }
}
