package top.doudou.base.web.filter.ip;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;
import top.doudou.base.properties.CustomFilterProperties;
import top.doudou.base.util.IpHelper;
import top.doudou.core.exception.AuthException;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @Description ip过滤器
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-29 13:55
 * @Version V1.0
 */
@Slf4j
@Component
public class IpFilter implements Filter {

    /**
     * ip白名单
     */
    public static final String ALLOW = "allow";
    /**
     * ip黑名单
     */
    public static final String DENY = "deny";
    /**
     * 响应信息
     */
    public static final String MSG = "IP access denied";

    private CustomFilterProperties customFilterProperties;

    public IpFilter(CustomFilterProperties customFilterProperties){
        this.customFilterProperties = customFilterProperties;
    }


    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        String ip = IpHelper.getRequestIp(req);
        if (CollectionUtils.isNotEmpty(customFilterProperties.getDeny())) {
            if (customFilterProperties.getDeny().contains(ip)) {
                handleMsg(response, ip);
                return;
            }
        } else {
            if (CollectionUtils.isNotEmpty(customFilterProperties.getAllow())) {
                if (customFilterProperties.getAllow().contains(ip)) {
                    chain.doFilter(request, response);
                } else {
                    handleMsg(response, ip);
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {

    }

    private void handleMsg(ServletResponse response, String ip) throws IOException {
        log.error("This ip can't all access [IP]: {}", ip);
        throw new AuthException("{} ,ip:{]",MSG,ip);
    }
}
