package top.doudou.base.web.filter.xxs;


import org.apache.commons.lang3.StringUtils;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-29 11:08
 * @Version V1.0
 */
public class ValidateUtil {

    // xss 忽略字符
    public static final String[] forbidden = {"\\bselect\\b", "\\bor\\b", "\\bdelete\\b", "\\bjoin\\b", "\\btable\\b"
            , "\\bdrop\\b", "\\biframe\\b", "\\bwindow\\b", "\\b_\\b", "\\+", "%", "\\<", "\\>", "'", "=",
            "%3C", "\\(", "%28", "alert", "eval((.*))", "script", "location.href"};

    /**
     * is Contains Forbidden Character
     *
     * @param str String str
     * @return boolean
     */
    public static boolean isContainsDefaultXSSForbiddenCharacter(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        } else {
            for (String reg : forbidden) {
                str = str.toLowerCase();
                String me = str.replaceAll(reg, "invalid character");
                if (me.length() != str.length()) {
                    return true;
                }
            }
        }
        return false;
    }
}
