package top.doudou.base.web.filter.xxs;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import top.doudou.base.properties.CustomFilterProperties;
import top.doudou.base.web.filter.AbstractUrlMatcher;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @Description 定义xss过滤
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-28 16:02
 * @Version V1.0
 */
@Slf4j
@Component
public class XssFilter extends AbstractUrlMatcher implements Filter {

    private Set<String> excluded = null;

    private FilterConfig filterConfig = null;

    public static final String IGNORES = "excludes";

    private CustomFilterProperties customFilterProperties;

    public XssFilter(CustomFilterProperties customFilterProperties){
        this.customFilterProperties = customFilterProperties;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException,ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        HttpServletResponse res = (HttpServletResponse) response;
        res.addHeader("X-XSS-Protection", "1; mode=block");
        res.addHeader( "Cache-Control", "no-store" );
        res.addHeader( "Cache-Control", "no-cache" );
        res.addHeader("X-Content-Type-Options", "nosniff");
        res.setHeader("X-Frame-Options","DENY");
        if (isExcluded(req)) {
            filterChain.doFilter(request, response);
            return;
        }

        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest) request);
        filterChain.doFilter(xssRequest, response);
    }


    /**
     * 判断是否是例外接口例外
     *
     * @param request
     * @return
     */
    private boolean isExcluded(HttpServletRequest request) {
        String url0 = request.getRequestURI();
        return this.isMatches(excluded, url0);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String excludedString = filterConfig.getInitParameter(IGNORES);
        excluded = customFilterProperties.getExcludeXssUrl();
        if (StringUtils.isNotEmpty(excludedString)) {
            excluded.addAll(Collections.unmodifiableSet(
                    new HashSet<>(Arrays.asList(excludedString.split(";", 0)))));
        }
    }

    @Override
    public void destroy() {}

}