package top.doudou.base.web.filter.xxs;

import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.doudou.base.properties.CustomFilterProperties;

import java.util.Map;

/**
 * @Description xss过滤器配置
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-28 16:02
 * @Version V1.0
 */
@Configuration
@EnableConfigurationProperties(CustomFilterProperties.class)
public class XssFilterConfig {

    @Autowired
    private CustomFilterProperties customFilterProperties;

    @Bean
    @ConditionalOnProperty(name = "filter.xss.enabled",havingValue = "true",matchIfMissing = false)
    public FilterRegistrationBean xssFilterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(new XssFilter(customFilterProperties));
        filterRegistrationBean.setOrder(1);
        filterRegistrationBean.setEnabled(true);
        filterRegistrationBean.addUrlPatterns("/*");
        Map<String, String> initParameters = Maps.newHashMap();
        initParameters.put("excludes", "/favicon.ico,/img/*,/js/*,/css/*");
        filterRegistrationBean.setInitParameters(initParameters);
        return filterRegistrationBean;
    }

}