package top.doudou.base.web.resolver;


import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

/**
 * @Author: 傻男人
 * @Date: 2020/6/15 10:01
 * @Version: 1.0
 * @Description: 登录用户信息拦截器
 */
public abstract class AbsLoginMethodArgumentResolver<T> implements HandlerMethodArgumentResolver {

    private Class<T> target;

    public AbsLoginMethodArgumentResolver(Class<T> target){
        this.target = target;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class clazz = parameter.getParameterType();
        return target.equals(clazz);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) {
        Class clazz = parameter.getParameterType();
        if (target.equals(clazz)) {
            return getLoginUser(parameter,modelAndViewContainer,nativeWebRequest,webDataBinderFactory);
        }
        return null;
    }

    /**
     * 获取登录用户的信息
     * @param parameter
     * @param modelAndViewContainer
     * @param nativeWebRequest
     * @param webDataBinderFactory
     * @return
     */
    public abstract T getLoginUser(MethodParameter parameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory);

}
