package top.andoudou.common.client;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import top.doudou.common.tool.aspect.WriteLogToFile;

import java.io.File;
import java.lang.annotation.Annotation;

/**
 * @Author: 傻男人
 * @Date: 2020/6/19 15:38
 * @Version: 1.0
 * @Description: 统计fegin的耗时信息
 */
@Component
public class FeignCostTimeAdvisor extends AbstractPointcutAdvisor {

    private static final String RPC_LOG = "."+ File.separator+"customLog"+ File.separator+"rpc.log";

    public FeignCostTimeAdvisor() {

    }

    public static boolean existsAnnotation(Class<?> cs, Class<? extends Annotation> annotation) {
        boolean rs = cs.isAnnotationPresent(annotation);
        if (!rs) {
            rs = cs.getSuperclass() != null && existsAnnotation(cs.getSuperclass(), annotation);
        }
        if (!rs) {
            Class<?>[] interfaces = cs.getInterfaces();
            for (Class<?> f : interfaces) {
                rs = existsAnnotation(f, annotation);
                if (rs) {
                    break;
                }
            }
        }
        if (!rs) {
            Annotation[] annotations = cs.getAnnotations();
            for (Annotation an : annotations) {
                rs = annotation.isAssignableFrom(an.getClass());
                if (rs) {
                    break;
                }
            }
        }
        return rs;
    }

    @Override
    public Pointcut getPointcut() {
        return new Pointcut() {
            @Override
            public ClassFilter getClassFilter() {
                return (Class<?> clazz) -> existsAnnotation(clazz, FeignClient.class);
            }

            @Override
            public MethodMatcher getMethodMatcher() {
                return MethodMatcher.TRUE;
            }
        };
    }

    @Override
    public Advice getAdvice() {
        return (MethodInterceptor) (MethodInvocation invocation) -> {
            try{
                long start = System.currentTimeMillis();
                Object result = invocation.proceed();
                long end = System.currentTimeMillis();
                String rpc = "cost(ms)：" + (end - start) + "       "+invocation.getMethod();
                if(rpc.contains("java.lang.String java.lang.Object.toString()")){
                    return result;
                }
                if(rpc.contains("com.zhcf.carloan.commons.utils.JsonResponse")){
                    rpc = rpc.replace("com.zhcf.carloan.commons.utils.JsonResponse","JsonResponse")
                            .replaceAll("com.zhcf.carloan.","")
                            .replaceAll("com.zhcf.client.","")
                            .replace("public abstract","");
                }
                FeginInfo.setRequestInfo(rpc);
                FeginInfo.setResult(result);
                return result;
            }catch (Exception e){
                FeginInfo.setResult(e.getLocalizedMessage());
                throw e;
            }finally {
                System.out.println("===>   "+FeginInfo.getCurrent().toString());
                WriteLogToFile.asyncLogToFile(RPC_LOG,FeginInfo.getCurrent().toString());
                FeginInfo.removeCurrent();
            }
        };
    }


}
