package top.andoudou.common.client;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * @Author: 傻男人
 * @Date: 2020/6/19 15:38
 * @Version: 1.0
 * @Description:
 */
@Slf4j
public class FeignHeadersInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {
        String path = template.path();
        if(StringUtils.isNotEmpty(template.queryLine())){
            path = path+ template.queryLine();
        }
        FeignInfo.setUrlInfo(template.method() + "   "+ path +"    "+ (null != template.body() ? new String(template.body()) : ""));
        HttpServletRequest request = getHttpServletRequest();
        if (Objects.isNull(request)) {
            log.info("{}，feign中获取的request：{}",template.method(),request);
            return;
        }
        Map<String, String> headers = getHeaders(request);
        if (headers.size() > 0) {
            headers.forEach((key,value)->template.header(key, value));
        }
    }

    private HttpServletRequest getHttpServletRequest() {
        try {
            // 这种方式获取的HttpServletRequest是线程安全的
            return ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
        } catch (Exception e) {
            return null;
        }
    }

    private Map<String, String> getHeaders(HttpServletRequest request) {
        Map<String, String> map = new LinkedHashMap<>();
        Enumeration<String> enums = request.getHeaderNames();
        while (enums.hasMoreElements()) {
            String key = enums.nextElement();
            String value = request.getHeader(key);
            map.put(key, value);
        }

        return map;
    }
}