package top.andoudou.common.client;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-27 15:31
 * @Version V1.0
 */
@Slf4j
@Data
public class FeignInfo {

    private static final ThreadLocal<FeignInfo> LOCAL = new ThreadLocal<>();

    /**
     * 请求的时间  请求的类的信息
     */
    private String requestInfo;

    /**
     * url的信息  参数信息
     */
    private String urlInfo;

    /**
     * fegin返回的结果
     */
    private Object result;

    private FeignInfo(){}

    public static FeignInfo setUrlInfo(String urlInfo){
        FeignInfo current = getCurrent();
        current.urlInfo = urlInfo;
        return current;
    }

    public static FeignInfo setRequestInfo(String requestInfo){
        FeignInfo current = getCurrent();
        current.requestInfo = requestInfo;
        return current;
    }

    public static FeignInfo setResult(Object result){
        FeignInfo current = getCurrent();
        current.result = result;
        return current;
    }

    public static FeignInfo getCurrent() {
        FeignInfo data = LOCAL.get();
        if (data == null) {
            data = new FeignInfo();
            LOCAL.set(data);
        }
        return LOCAL.get();
    }

    public static void removeCurrent() {
        LOCAL.remove();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if(StringUtils.isNotEmpty(urlInfo)){
            sb.append("feign调用信息:   " + urlInfo + "\n");
        }
        if(StringUtils.isNotEmpty(requestInfo)){
            sb.append("\t\t耗时:   " + requestInfo+ "\n");
        }
        if(null != result){
            sb.append("\t\tresult:   " + result);
        }
        return  sb.toString();
    }
}
