/*
 * Decompiled with CFR 0.152.
 */
package top.andoudou.common.client;

import java.io.File;
import java.lang.annotation.Annotation;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import top.andoudou.common.client.FeignInfo;
import top.doudou.base.util.file.FileReadAndWriteUtil;

@Component
public class FeignCostTimeAdvisor
extends AbstractPointcutAdvisor {
    private static final Logger log = LoggerFactory.getLogger(FeignCostTimeAdvisor.class);
    private static final String RPC_LOG = "." + File.separator + "customLog" + File.separator + "rpc.log";

    public static boolean existsAnnotation(Class<?> cs, Class<? extends Annotation> annotation) {
        int n;
        int n2;
        Object[] objectArray;
        boolean rs = cs.isAnnotationPresent(annotation);
        if (!rs) {
            boolean bl = rs = cs.getSuperclass() != null && FeignCostTimeAdvisor.existsAnnotation(cs.getSuperclass(), annotation);
        }
        if (!rs) {
            Object f;
            Class<?>[] interfaces = cs.getInterfaces();
            objectArray = interfaces;
            n2 = objectArray.length;
            for (n = 0; n < n2 && !(rs = FeignCostTimeAdvisor.existsAnnotation(f = objectArray[n], annotation)); ++n) {
            }
        }
        if (!rs) {
            Object an;
            Annotation[] annotations = cs.getAnnotations();
            objectArray = annotations;
            n2 = objectArray.length;
            for (n = 0; n < n2 && !(rs = annotation.isAssignableFrom((an = objectArray[n]).getClass())); ++n) {
            }
        }
        return rs;
    }

    public Pointcut getPointcut() {
        return new Pointcut(){

            public ClassFilter getClassFilter() {
                return clazz -> FeignCostTimeAdvisor.existsAnnotation(clazz, FeignClient.class);
            }

            public MethodMatcher getMethodMatcher() {
                return MethodMatcher.TRUE;
            }
        };
    }

    public Advice getAdvice() {
        return invocation -> {
            try {
                long start = System.currentTimeMillis();
                Object result = invocation.proceed();
                long end = System.currentTimeMillis();
                String rpc = "cost(ms)\uff1a" + (end - start) + "       " + invocation.getMethod();
                if (rpc.contains("java.lang.String java.lang.Object.toString()")) {
                    Object object = result;
                    return object;
                }
                if (rpc.contains("com.zhcf.carloan.commons.utils.JsonResponse")) {
                    rpc = rpc.replace("com.zhcf.carloan.commons.utils.JsonResponse", "JsonResponse").replaceAll("com.zhcf.carloan.", "").replaceAll("com.zhcf.client.", "").replace("public abstract", "");
                }
                if (rpc.contains("top.doudou.base.respond.Result")) {
                    rpc = rpc.replace("top.doudou.base.respond.Result", "Result").replace("public abstract", "");
                }
                FeignInfo.setRequestInfo(rpc);
                FeignInfo.setResult(result);
                Object object = result;
                return object;
            }
            catch (Exception e) {
                FeignInfo.setResult(e.getLocalizedMessage());
                throw e;
            }
            finally {
                log.info("===>   " + FeignInfo.getCurrent().toString());
                FileReadAndWriteUtil.writeObjToFile((String)FeignInfo.getCurrent().toString(), (File)new File(RPC_LOG));
                FeignInfo.removeCurrent();
            }
        };
    }
}

