package top.andoudou.common.client;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import top.doudou.base.util.ServletUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: 傻男人
 * @Date: 2020/6/19 15:38
 * @Version: 1.0
 * @Description:
 */
@Slf4j
public class FeignHeadersInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {
        String path = template.path();
        if(StringUtils.isNotEmpty(template.queryLine())){
            path = path+ template.queryLine();
        }
        FeignInfo.setUrlInfo(template.method() + "   "+ path +"    "+ (null != template.body() ? new String(template.body()) : ""));
        HttpServletRequest request = ServletUtils.getRequest();
        if (Objects.isNull(request)) {
            log.info("{}，feign中获取的request：{}",template.method(),request);
            return;
        }
        Map<String, String> headers = ServletUtils.getHeaders(request,false);
        if (headers.size() > 0) {
            headers.forEach((key,value)->template.header(key, value));
        }
    }

}