/*
 * Decompiled with CFR 0.152.
 */
package top.andoudou.common.client;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignInfo {
    private static final Logger log = LoggerFactory.getLogger(FeignInfo.class);
    private static final ThreadLocal<FeignInfo> LOCAL = new ThreadLocal();
    private String requestInfo;
    private String urlInfo;
    private Object result;

    private FeignInfo() {
    }

    public static FeignInfo setUrlInfo(String urlInfo) {
        FeignInfo current = FeignInfo.getCurrent();
        current.urlInfo = urlInfo;
        return current;
    }

    public static FeignInfo setRequestInfo(String requestInfo) {
        FeignInfo current = FeignInfo.getCurrent();
        current.requestInfo = requestInfo;
        return current;
    }

    public static FeignInfo setResult(Object result) {
        FeignInfo current = FeignInfo.getCurrent();
        current.result = result;
        return current;
    }

    public static FeignInfo getCurrent() {
        FeignInfo data = LOCAL.get();
        if (data == null) {
            data = new FeignInfo();
            LOCAL.set(data);
        }
        return LOCAL.get();
    }

    public static void removeCurrent() {
        LOCAL.remove();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.urlInfo)) {
            sb.append("feign\u8c03\u7528\u4fe1\u606f:   " + this.urlInfo + "\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.requestInfo)) {
            sb.append("\t\t\u8017\u65f6:   " + this.requestInfo + "\n");
        }
        if (null != this.result) {
            sb.append("\t\tresult:   " + this.result);
        }
        return sb.toString();
    }

    public String getRequestInfo() {
        return this.requestInfo;
    }

    public String getUrlInfo() {
        return this.urlInfo;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeignInfo)) {
            return false;
        }
        FeignInfo other = (FeignInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestInfo = this.getRequestInfo();
        String other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        String this$urlInfo = this.getUrlInfo();
        String other$urlInfo = other.getUrlInfo();
        if (this$urlInfo == null ? other$urlInfo != null : !this$urlInfo.equals(other$urlInfo)) {
            return false;
        }
        Object this$result = this.getResult();
        Object other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeignInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        String $urlInfo = this.getUrlInfo();
        result = result * 59 + ($urlInfo == null ? 43 : $urlInfo.hashCode());
        Object $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }
}

