/*
 * Decompiled with CFR 0.152.
 */
package top.andoudou.common.client;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.andoudou.common.client.FeignInfo;
import top.doudou.base.util.ServletUtils;

public class FeignHeadersInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FeignHeadersInterceptor.class);

    public void apply(RequestTemplate template) {
        String path = template.path();
        if (StringUtils.isNotEmpty((CharSequence)template.queryLine())) {
            path = path + template.queryLine();
        }
        FeignInfo.setUrlInfo(template.method() + "   " + path + "    " + (null != template.body() ? new String(template.body()) : ""));
        HttpServletRequest request = ServletUtils.getRequest();
        if (Objects.isNull(request)) {
            log.info("{}\uff0cfeign\u4e2d\u83b7\u53d6\u7684request\uff1a{}", (Object)template.method(), (Object)request);
            return;
        }
        Map headers = ServletUtils.getHeaders((HttpServletRequest)request, (boolean)false);
        if (headers.size() > 0) {
            headers.forEach((key, value) -> template.header(key, new String[]{value}));
        }
    }
}

