package top.doudou.common.quartz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;
import top.doudou.base.page.PageInfo;
import top.doudou.base.respond.Result;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobAddDto;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobDto;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobUpdateDto;
import top.doudou.common.quartz.service.SysScheduleJobService;
import top.doudou.common.tool.dto.PageModel;
import top.doudou.common.tool.utils.ParamUtil;

import javax.validation.Valid;
import java.util.List;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务  前端控制器
 */
@Slf4j
@RestController
@RequestMapping("/sys/schedule")
@Api(value = "定时任务信息",tags = "定时任务信息")
public class SysScheduleJobController {

    @Autowired
    private SysScheduleJobService sysScheduleJobService;

    /**
     * 添加定时任务
     * @param sysScheduleJobAddDto
     * @param result
     * @return
     */
    @ApiOperation(value = "添加定时任务",notes = "添加定时任务")
    @PostMapping
    public Result<SysScheduleJobDto> save(@Valid @RequestBody @ApiParam(value = "定时任务添加dto",required = true) SysScheduleJobAddDto sysScheduleJobAddDto,
                                          BindingResult result) {
        ParamUtil.getErrorMsg(result);
        SysScheduleJobDto sysScheduleJobDto = sysScheduleJobService.save(sysScheduleJobAddDto);
        return Result.ok(sysScheduleJobDto);
    }

    /**
     * 根据主键id批量逻辑删除定时任务--逻辑删除
     * @param primaryIds
     * @return 删除的条数
     */
    @ApiOperation(value = "根据主键id批量逻辑删除定时任务",notes = "根据主键id批量逻辑删除定时任务")
    @ApiImplicitParam(name = "primaryIds",value="定时任务ids",dataType="String",required = true)
    @DeleteMapping(value = "/batch/logic")
    public Result<Integer> logicDelete(@RequestParam("primaryIds") String primaryIds) {
        Integer number = sysScheduleJobService.logicDelete(primaryIds);
        return Result.ok(number);
    }

    /**
    * 根据主键id批量直接删除定时任务--物理删除
    * @param primaryIds
    * @return 删除的条数
    */
    @ApiOperation(value = "根据主键id批量直接删除定时任务",notes = "根据主键id批量直接删除定时任务")
    @ApiImplicitParam(name = "primaryIds",value="定时任务ids",dataType="String",required = true)
    @DeleteMapping(value = "/batch/direct")
    public Result<Integer> directDelete(@RequestParam("primaryIds") String primaryIds) {
        Integer number = sysScheduleJobService.directDelete(primaryIds);
        return Result.ok(number);
    }

    /**
     * 根据id修改定时任务
     * @param sysScheduleJobUpdateDto
     * @param result
     * @return 修改的条数
     */
    @ApiOperation(value = "根据id修改定时任务",notes = "修改定时任务")
    @PutMapping
    public Result<Integer> updateById(@Valid @RequestBody @ApiParam(value = "定时任务修改dto",required = true) SysScheduleJobUpdateDto sysScheduleJobUpdateDto,
           BindingResult result) {
        ParamUtil.getErrorMsg(result);
        Integer sum = sysScheduleJobService.updateById(sysScheduleJobUpdateDto);
        return Result.ok(sum);
    }

    /**
     * 根据ids查询定时任务
     * @param primaryIds 定时任务的ids
     * @return
     */
    @ApiOperation(value = "根据ids查询定时任务",notes = "根据ids查询定时任务")
    @ApiImplicitParam(name = "primaryIds",value="定时任务ids",dataType="String",required = true)
    @GetMapping(value = "/list")
    public Result<List<SysScheduleJobDto>> findByPrimaryIds(@RequestParam("primaryIds")  String primaryIds) {
        List<SysScheduleJobDto> list = sysScheduleJobService.findByPrimaryIds(primaryIds);
        return Result.ok(list);
    }

    /**
    * 根据id查询定时任务
    * @param primaryId   定时任务的id
    * @return 返回主键为id的实体，如果为空则为null
    */
    @ApiOperation(value = "根据id查询定时任务",notes = "根据id查询定时任务")
    @ApiImplicitParam(name = "primaryId",value="定时任务的id",dataType="Long",required = true,paramType = "path")
    @GetMapping(value = "/primaryId")
    public Result<SysScheduleJobDto> findByPrimaryId(@RequestParam("primaryId")Long primaryId) {
        SysScheduleJobDto result = sysScheduleJobService.findByPrimaryId(primaryId);
        return Result.ok(result);
    }

    /**
    * 分页查询定时任务
    *
    * @return
    */
    @ApiOperation(value = "分页查询定时任务", notes = "分页查询定时任务")
    @GetMapping(value = "/page")
    public Result<IPage<SysScheduleJobDto>> findByPageHelper(@Valid @ApiParam("分页信息") PageInfo pageInfo) {
        return Result.ok(sysScheduleJobService.findByPageHelper(pageInfo));
    }


    /**
     * 立即执行任务定时任务
     * @param primaryIds
     * @return
     */
    @ApiOperation(value = "立即执行任务定时任务", notes = "立即执行任务定时任务")
	@PostMapping("/run")
	public Result<Boolean> run(@RequestParam("primaryIds") String primaryIds){
        return Result.ok(sysScheduleJobService.run(primaryIds));
	}

    /**
     * 暂停定时任务
     * @param primaryIds
     * @return
     */
    @ApiOperation(value = "暂停定时任务", notes = "暂停定时任务")
	@PostMapping("/pause")
	public Result<Boolean> pause(@RequestParam("primaryIds") String primaryIds){
        return Result.ok(sysScheduleJobService.pause(primaryIds));
	}

    /**
     * 恢复定时任务
     * @param primaryIds
     * @return
     */
    @ApiOperation(value = "恢复定时任务", notes = "恢复定时任务")
	@PostMapping("/resume")
	public Result<Boolean> resume(@RequestParam("primaryIds") String primaryIds){
        return Result.ok(sysScheduleJobService.resume(primaryIds));
	}

    /**
     * 停止定时任务
     * @param primaryIds
     * @return
     */
    @ApiOperation(value = "停止定时任务", notes = "停止定时任务")
    @PostMapping("/stop")
    public Result<Boolean> stop(@RequestParam("primaryIds") String primaryIds){
        return Result.ok(sysScheduleJobService.stop(primaryIds));
    }


    /**
     * 重启数据库中所有的Job(将数据库中暂停与停止的任务全部重启)
     * @return 重启的个数
     */
    @ApiOperation(value = "重启数据库中所有的Job(将数据库中暂停与停止的任务全部重启)",notes = "重启数据库中所有的Job(将数据库中暂停与停止的任务全部重启)")
    @PostMapping("/refresh/all")
    public Result<Integer> refreshAll() {
        return Result.ok(sysScheduleJobService.reStartAllJobs());
    }
}
