package top.doudou.common.quartz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import top.doudou.base.page.PageInfo;
import top.doudou.base.respond.Result;
import top.doudou.common.quartz.entity.dto.sysschedulejoblog.SysScheduleJobLogDto;
import top.doudou.common.quartz.service.SysScheduleJobLogService;

/**
 * @author 傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务日志  前端控制器
 */
@Slf4j
@RestController
@RequestMapping("/sys/schedule/log")
@Api(value = "定时任务日志信息", tags = "定时任务日志信息")
public class SysScheduleJobLogController {

    @Autowired
    private SysScheduleJobLogService sysScheduleJobLogService;

    /**
     * 根据id查询定时任务日志
     *
     * @param primaryId 定时任务日志的id
     * @return 返回主键为id的实体，如果为空则为null
     */
    @ApiOperation(value = "根据id查询定时任务日志", notes = "根据id查询定时任务日志")
    @ApiImplicitParam(name = "primaryId", value = "定时任务日志的id", dataType = "Long", required = true, paramType = "path")
    @GetMapping(value = "/schedule_job_log/{primaryId}/primaryId")
    public Result<SysScheduleJobLogDto> findByPrimaryId(@PathVariable("primaryId") Long primaryId) {
        SysScheduleJobLogDto result = sysScheduleJobLogService.findByPrimaryId(primaryId);
        return Result.ok(result);
    }


    /**
     * 定时任务日志列表
     *
     * @param jobId    任务id
     * @param pageInfo 分页的信息
     * @return
     */
    @ApiOperation(value = "定时任务日志列表", notes = "定时任务日志列表")
    @GetMapping("/page")
    @ApiImplicitParam(name = "jobId", value = "任务id", dataType = "Long", required = false, paramType = "query")
    public Result<IPage<SysScheduleJobLogDto>> findByPageHelper(@RequestParam("jobId") Long jobId,
                                                                @ApiParam("分页信息") PageInfo pageInfo) {
        IPage<SysScheduleJobLogDto> result = sysScheduleJobLogService.findByPageHelper(jobId, pageInfo);
        return Result.ok(result);
    }
}
