package top.doudou.common.quartz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务详情信息
 */
@Data
@TableName(value = "sys_schedule_job",resultMap = "BaseResultMap")
public class SysScheduleJob implements Serializable {

    private static final long serialVersionUID = -5137692683705109766L;
    /**
     * 任务id
     */
	private Long id;
    /**
     * spring bean名称
     */
	@TableField("bean")
	private String bean;
    /**
     * 方法名
     */
	@TableField("method")
	private String method;
    /**
     * 任务参数
     */
	private String params;
    /**
     * cron表达式
     */
	private String cron;
    /**
     * 任务状态  0：正常  1：暂停  2停止
     */
	private Integer status;
    /**
     * 备注
     */
	private String remark;

    /**
     * 创建时间
     */
	@TableField("create_date")
	private Date createDate;

    /**
     * 更新时间
     */
	@TableField("update_date")
	private Date updateDate;

    /**
     * 删除的状态标识
     */
	@TableField("del_flag")
	private Integer delFlag;

	public class Meta {
        public static final String id = "id";
        public static final String bean = "bean";
        public static final String method = "method";
        public static final String params = "params";
        public static final String cron = "cron";
        public static final String status = "status";
        public static final String remark = "remark";
        public static final String createDate = "create_date";
        public static final String updateDate = "update_date";
        public static final String delFlag = "del_flag";
    }
}