package top.doudou.common.quartz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务日志
 */
@Data
@TableName(value = "sys_schedule_job_log",resultMap = "BaseResultMap")
public class SysScheduleJobLog implements Serializable {

    private static final long serialVersionUID = -5811132993220801991L;
    /**
     * id
     */
	private Long id;
    /**
     * 任务id
     */
	@TableField("job_id")
	private Long jobId;
    /**
     * spring bean名称
     */
	private String bean;
    /**
     * 方法名
     */
	private String method;
    /**
     * 参数
     */
	private String params;
    /**
     * 任务状态 0：成功  1：失败
     */
	private Integer status;
    /**
     * 失败信息
     */
	private String error;
    /**
     * 耗时(单位：毫秒)
     */
	private Integer time;
    /**
     * 创建时间
     */
	@TableField("create_date")
	private Date createDate;

	public class Meta {
        public static final String id = "id";
        public static final String jobId = "job_id";
        public static final String bean = "bean";
        public static final String method = "method";
        public static final String params = "params";
        public static final String status = "status";
        public static final String error = "error";
        public static final String time = "time";
        public static final String createDate = "create_date";
    }
}