package top.doudou.common.quartz.entity.dto.sysschedulejob;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务详情信息dto类
 */
@Data
@ApiModel("定时任务详情信息")
public class SysScheduleJobDto implements Serializable {

    private static final long serialVersionUID = -5703226903812568543L;
    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long id;
    /**
     * spring bean名称
     */
    @ApiModelProperty("spring bean名称")
    private String bean;
    /**
     * 方法名
     */
    @ApiModelProperty("方法名")
    private String method;
    /**
     * 任务参数
     */
    @ApiModelProperty("任务参数(key为参数名,value为参数值的json字符串)")
    private String params;
    /**
     * cron表达式
     */
    @ApiModelProperty("cron表达式")
    private String cron;
    /**
     * 任务状态  0：正常  1：暂停  2停止
     */
    @ApiModelProperty("任务状态  0：正常  1：暂停  2停止")
    private Integer status;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createDate;

}