package top.doudou.common.quartz.entity.dto.sysschedulejob;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务详情信息修改dto类
 */
@Data
@ApiModel("定时任务详情信息修改dto")
public class SysScheduleJobUpdateDto implements Serializable {

    private static final long serialVersionUID = -7956130749662089045L;
    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务id",required = true)
    private Long id;
    /**
     * spring bean名称
     */
    @ApiModelProperty(value = "spring bean名称",required = true)
    private String bean;

    /**
     * 方法名
     */
    @ApiModelProperty(value = "方法名",required = true)
    private String method;

    /**
     * 任务参数
     */
    @ApiModelProperty(value = "任务参数(key为参数名,value为参数值的json字符串)",required = true)
    private Map<String,Object> params;


    /**
     * cron表达式
     */
    @ApiModelProperty(value = "cron表达式",required = true)
    private String cron;
    /**
     * 任务状态  0：正常  1：暂停  2停止
     */
    @ApiModelProperty(value = "任务状态  0：正常  1：暂停  2停止",required = true)
    private Integer status;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注",required = true)
    private String remark;

}