package top.doudou.common.quartz.entity.dto.sysschedulejoblog;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务日志添加dto类
 */
@Data
@ApiModel("定时任务日志添加dto")
public class SysScheduleJobLogAddDto implements Serializable {

    private static final long serialVersionUID = 1633971649673065686L;
    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务id",required = true)
    private Long jobId;

    /**
     * spring bean名称
     */
    @ApiModelProperty(value = "spring bean名称",required = true)
    private String bean;

    /**
     * 方法名
     */
    @ApiModelProperty(value = "方法名",required = true)
    private String method;

    /**
     * 参数
     */
    @ApiModelProperty("任务参数(key为参数名,value为参数值的json字符串)")
    private String params;

    /**
     * 任务状态 0：成功  1：失败
     */
    @ApiModelProperty(value = "任务状态 0：成功  1：失败",required = true)
    private Integer status;

    /**
     * 失败信息
     */
    @ApiModelProperty(value = "失败信息",required = true)
    private String error;

    /**
     * 耗时(单位：毫秒)
     */
    @ApiModelProperty(value = "耗时(单位：毫秒)",required = true)
    private Integer time;



}