package top.doudou.common.quartz.entity.dto.sysschedulejoblog;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务日志dto类
 */
@Data
@ApiModel("定时任务日志")
public class SysScheduleJobLogDto implements Serializable {

    private static final long serialVersionUID = 7204484061230668708L;
    /**
     * id
     */
    @ApiModelProperty("id")
    private Long id;
    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long jobId;
    /**
     * spring bean名称
     */
    @ApiModelProperty("spring bean名称")
    private String bean;
    /**
     * 方法名
     */
    @ApiModelProperty("方法名")
    private String method;
    /**
     * 参数
     */
    @ApiModelProperty("参数")
    private String params;
    /**
     * 任务状态 0：成功  1：失败
     */
    @ApiModelProperty("任务状态 0：成功  1：失败")
    private Integer status;
    /**
     * 失败信息
     */
    @ApiModelProperty("失败信息")
    private String error;
    /**
     * 耗时(单位：毫秒)
     */
    @ApiModelProperty("耗时(单位：毫秒)")
    private Integer time;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createDate;

}