package top.doudou.common.quartz.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import top.doudou.base.page.PageInfo;
import top.doudou.common.quartz.entity.dto.sysschedulejoblog.SysScheduleJobLogAddDto;
import top.doudou.common.quartz.entity.dto.sysschedulejoblog.SysScheduleJobLogDto;

import java.util.List;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务日志 服务类
 */
public interface SysScheduleJobLogService  {
    /**
     * 添加定时任务日志
     * @param sysScheduleJobLogAddDto
     * @return
     */
    SysScheduleJobLogDto save(SysScheduleJobLogAddDto sysScheduleJobLogAddDto);

    /**
     * 批量添加定时任务日志
     * @param list  批量的list
     * @return
     */
    boolean batchSave(List<SysScheduleJobLogAddDto> list);


    /**
     * 根据主键id批量直接删除定时任务日志--物理删除
     * @param primaryIds
     * @return 删除的条数
     */
     Integer directDelete(String primaryIds);

    /**
     * 根据ids查询定时任务日志
     * @param primaryIds
     * @return
     */
    List<SysScheduleJobLogDto> findByPrimaryIds(String primaryIds);

    /**
     * 根据id查询定时任务日志
     * @param primaryId
     * @return 返回主键为primaryId的实体，如果为空则为null
     */
    SysScheduleJobLogDto findByPrimaryId(Long primaryId);

    /**
     * 定时任务日志列表
     * @param jobId  任务id
     * @param pageInfo  分页的信息
     * @return
     */
    IPage<SysScheduleJobLogDto> findByPageHelper(Long jobId, PageInfo pageInfo);

}
