package top.doudou.common.quartz.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import top.doudou.base.page.PageInfo;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobAddDto;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobDto;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobUpdateDto;
import top.doudou.common.tool.dto.PageModel;

import java.util.List;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务详情信息 服务类
 */
public interface SysScheduleJobService  {
    /**
     * 添加定时任务详情信息
     * @param sysScheduleJobAddDto
     * @return
     */
    SysScheduleJobDto save(SysScheduleJobAddDto sysScheduleJobAddDto);

    /**
     * 保存并开始定时任务
     * @param scheduleJob
     */
    SysScheduleJobDto saveAndStart(SysScheduleJobAddDto scheduleJob);

    /**
     * 批量添加定时任务详情信息
     * @param list  批量的list
     * @return
     */
    boolean batchSave(List<SysScheduleJobAddDto> list);

    /**
     * 根据主键id批量逻辑删除定时任务详情信息--逻辑删除
     * @param primaryIds
     * @return 删除的条数
     */
     Integer logicDelete(String primaryIds);

    /**
     * 根据主键id批量直接删除定时任务详情信息--物理删除
     * @param primaryIds
     * @return 删除的条数
     */
     Integer directDelete(String primaryIds);


    /**
     * 根据id修改定时任务详情信息
     * @param sysScheduleJobUpdateDto
     * @return 修改的条数
     */
    Integer updateById(SysScheduleJobUpdateDto sysScheduleJobUpdateDto);

    /**
     * 根据ids查询定时任务详情信息
     * @param primaryIds
     * @return
     */
    List<SysScheduleJobDto> findByPrimaryIds(String primaryIds);

    /**
     * 根据id查询定时任务详情信息
     * @param primaryId
     * @return 返回主键为primaryId的实体，如果为空则为null
     */
    SysScheduleJobDto findByPrimaryId(Long primaryId);

    /**
     *  分页查询定时任务详情信息
     * @param pageInfo
     * @return
     */
    IPage<SysScheduleJobDto> findByPageHelper(PageInfo pageInfo);

    /**
     * 立即执行任务定时任务
     * @param primaryIds  定时任务主键
     * @return
     */
    boolean run(String primaryIds);

    /**
     * 暂停定时任务
     * @param primaryIds 定时任务主键
     * @return
     */
    boolean pause(String primaryIds);

    /**
     * 恢复定时任务
     * @param primaryIds 定时任务主键
     * @return
     */
    boolean resume(String primaryIds);

    /**
     * 停止定时任务
     * @param primaryIds 定时任务主键
     * @return
     */
    boolean stop(String primaryIds);

    /**
     * 重启数据库中所有的Job
     * @return 重启的个数
     */
    Integer reStartAllJobs();
}
