package top.doudou.common.quartz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import top.doudou.base.convert.ConvertBeanUtils;
import top.doudou.base.page.PageInfo;
import top.doudou.base.util.FastAssert;
import top.doudou.common.quartz.dao.SysScheduleJobLogDao;
import top.doudou.common.quartz.entity.SysScheduleJobLog;
import top.doudou.common.quartz.entity.dto.sysschedulejoblog.SysScheduleJobLogAddDto;
import top.doudou.common.quartz.entity.dto.sysschedulejoblog.SysScheduleJobLogDto;
import top.doudou.common.quartz.service.SysScheduleJobLogService;
import top.doudou.common.tool.client.SuggestiveLanguage;
import top.doudou.common.tool.utils.IPageUtil;
import top.doudou.common.tool.utils.ListUtils;

import java.util.List;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2021-01-26
 * @Version: 1.0
 * @Description: 定时任务日志 服务实现类
 */
@Slf4j
@Service
public class SysScheduleJobLogServiceImpl extends ServiceImpl<SysScheduleJobLogDao, SysScheduleJobLog> implements SysScheduleJobLogService {

    /**
    * 添加定时任务日志
    * @param sysScheduleJobLogAddDto
    * @return
    */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SysScheduleJobLogDto save(SysScheduleJobLogAddDto sysScheduleJobLogAddDto) {
        SysScheduleJobLog sysScheduleJobLog = ConvertBeanUtils.copyProperties(sysScheduleJobLogAddDto,SysScheduleJobLog.class);
        this.baseMapper.insert(sysScheduleJobLog);
        return ConvertBeanUtils.copyProperties(sysScheduleJobLog,SysScheduleJobLogDto.class);
    }

    /**
     * 批量添加定时任务日志
     * @param list  批量的list
     * @return
     */
    @Override
    public boolean batchSave(List<SysScheduleJobLogAddDto> list) {
        List<SysScheduleJobLog> temp = ListUtils.copyList(list,SysScheduleJobLog.class);
        return this.saveBatch(temp);
    }

    /**
    * 根据主键id批量逻辑删除定时任务日志--物理删除
    * @param primaryIds
    * @return  删除的条数
    */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Integer directDelete(String primaryIds) {
        if(StringUtils.isBlank(primaryIds)){
            return 0;
        }
        List<Long> listId = ListUtils.stringToList(primaryIds);
        return this.baseMapper.deleteBatchIds(listId);
    }

    /**
     * 根据ids查询定时任务日志
     * @param primaryIds
     * @return
     */
    @Override
    public List<SysScheduleJobLogDto> findByPrimaryIds(String primaryIds) {
        List<Long> listIds = ListUtils.stringToList(primaryIds);
        QueryWrapper<SysScheduleJobLog> wrapper = Wrappers.query();
        wrapper.in(SysScheduleJobLog.Meta.id,listIds);
        List<SysScheduleJobLog> sysScheduleJobLogs = this.baseMapper.selectList(wrapper);
        return ListUtils.copyList(sysScheduleJobLogs,SysScheduleJobLogDto.class);
    }

    /**
     * 根据id查询定时任务日志
     * @param primaryId
     * @return 返回主键为primaryId的实体，如果为空则为null
     */
    @Override
    public SysScheduleJobLogDto findByPrimaryId(Long primaryId){
        FastAssert.notEmpty(primaryId, SuggestiveLanguage.notEmpty("主键"));
        SysScheduleJobLog sysScheduleJobLog = this.baseMapper.selectById(primaryId);
        if(sysScheduleJobLog == null){
            return null;
        }
        return ConvertBeanUtils.copyProperties(sysScheduleJobLog,SysScheduleJobLogDto.class);
    }

    /**
     * 定时任务日志列表
     * @param jobId  任务id
     * @param pageInfo  分页的信息
     * @return
     */
    @Override
    public IPage<SysScheduleJobLogDto> findByPageHelper(Long jobId,PageInfo pageInfo){
        Page page = new Page(pageInfo.getPageIndex(), pageInfo.getPageSize());
        IPage<SysScheduleJobLog> list = this.baseMapper.findByPageHelper(jobId,page);
        IPage<SysScheduleJobLogDto> result = IPageUtil.create(list,SysScheduleJobLogDto.class);
        return result;
    }


}
