package top.doudou.common.quartz.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.ReflectionUtils;
import top.doudou.base.convert.ConvertBeanUtils;
import top.doudou.base.exception.CustomException;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobDto;
import top.doudou.common.tool.context.SpringContextUtil;
import top.doudou.base.builder.JsonBuilder;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;


/**
 * 定时任务spring bean 执行定时任务
 * @author 傻男人
 */
@Slf4j
public class SpringBeanTaskUtil {
	
	public static void invokeMethod(SysScheduleJobDto scheduleJob) {
		Object target = SpringContextUtil.getBean(scheduleJob.getBean());
		try {
			Class<?> aClass = target.getClass();
			Map<String, Object> paramMap = ConvertBeanUtils.convert2Map(scheduleJob.getParams());
			if (MapUtils.isNotEmpty(paramMap)) {
				Method[] methods = aClass.getMethods();
				for(Method item : methods){
					if(!item.getName().equals(scheduleJob.getMethod())){
						continue;
					}
					Parameter[] parameters = item.getParameters();
					if(parameters.length != paramMap.size()){
						continue;
					}
					Object[] objs = new Object[parameters.length];
					for (int i = 0; i < parameters.length; i++) {
						Object o = paramMap.get(parameters[i].getName());
						objs[i] = convert(o,parameters[i].getType());
					}
					ReflectionUtils.makeAccessible(item);
					item.invoke(target, objs);
					return;
				}
			}
			Method method = aClass.getDeclaredMethod(scheduleJob.getMethod());
			ReflectionUtils.makeAccessible(method);
			method.invoke(target);
		} catch (Exception e) {
			log.info("执行定时任务失败,bean:{},method:{}失败的原因：{}",scheduleJob.getBean(),scheduleJob.getMethod(), e.getMessage());
			e.printStackTrace();
			throw new CustomException(e);
		}
	}

	private static boolean typeConvert(Object obj,Class<?> target){
		try {
			JsonBuilder.gson().fromJson(obj.toString(),target);
		}catch (Exception e){
			return false;
		}
		return true;
	}

	private static <T>T convert(Object obj,Class<T> target){
		if(null == target){
			throw new CustomException("target must be not null");
		}
		try {
			if(null == obj){
				log.info("obj:{} 为null",obj);
				return null;
			}
			if("java.lang.String".equals(target.getName())){
				return (T)obj;
			}
			return JsonBuilder.gson().fromJson(obj.toString(),target);
		}catch (Exception e){
			log.info("obj:{} 不能转换为：{}",obj,target);
			return null;
		}
	}
}
