/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.quartz.config;

import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.stereotype.Component;
import top.doudou.common.quartz.config.QuartzJob;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobDto;
import top.doudou.common.quartz.enums.ScheduleStatus;

@Component
public class ScheduleManager {
    private static final String JOB_NAME = "TASK_";
    private final Scheduler scheduler;

    private TriggerKey getTriggerKey(SysScheduleJobDto scheduleJob) {
        return TriggerKey.triggerKey((String)(JOB_NAME + scheduleJob.getId()));
    }

    private JobKey getJobKey(SysScheduleJobDto scheduleJob) {
        return JobKey.jobKey((String)(JOB_NAME + scheduleJob.getId()));
    }

    public CronTrigger getCronTrigger(SysScheduleJobDto scheduleJob) {
        try {
            return (CronTrigger)this.scheduler.getTrigger(this.getTriggerKey(scheduleJob));
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1CronTrigger\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    public void createScheduleJob(SysScheduleJobDto scheduleJob) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(QuartzJob.class).withIdentity(this.getJobKey(scheduleJob)).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCron()).withMisfireHandlingInstructionFireAndProceed();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.getTriggerKey(scheduleJob)).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            jobDetail.getJobDataMap().put("JOB_PARAM_KEY", (Object)scheduleJob);
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (scheduleJob.getStatus().equals(ScheduleStatus.PAUSE.getType())) {
                this.pauseJob(scheduleJob);
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public void updateScheduleJob(SysScheduleJobDto scheduleJob) {
        try {
            TriggerKey triggerKey = this.getTriggerKey(scheduleJob);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCron()).withMisfireHandlingInstructionFireAndProceed();
            CronTrigger trigger = this.getCronTrigger(scheduleJob);
            if (trigger == null) {
                this.createScheduleJob(scheduleJob);
                return;
            }
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            trigger.getJobDataMap().put("JOB_PARAM_KEY", (Object)scheduleJob);
            this.scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            if (scheduleJob.getStatus().equals(ScheduleStatus.PAUSE.getType())) {
                this.pauseJob(scheduleJob);
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public void run(SysScheduleJobDto scheduleJob) {
        try {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("JOB_PARAM_KEY", (Object)scheduleJob);
            this.scheduler.triggerJob(this.getJobKey(scheduleJob), dataMap);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u7acb\u5373\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public void pauseJob(SysScheduleJobDto scheduleJob) {
        try {
            this.scheduler.pauseJob(this.getJobKey(scheduleJob));
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public void resumeJob(SysScheduleJobDto scheduleJob) {
        try {
            this.scheduler.resumeJob(this.getJobKey(scheduleJob));
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public void deleteScheduleJob(SysScheduleJobDto scheduleJob) {
        try {
            this.scheduler.pauseTrigger(this.getTriggerKey(scheduleJob));
            this.scheduler.unscheduleJob(this.getTriggerKey(scheduleJob));
            this.scheduler.deleteJob(this.getJobKey(scheduleJob));
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public ScheduleManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

