/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.quartz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.doudou.base.page.PageInfo;
import top.doudou.base.respond.Result;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobAddDto;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobDto;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobUpdateDto;
import top.doudou.common.quartz.service.SysScheduleJobService;
import top.doudou.common.tool.utils.ParamUtil;

@RestController
@RequestMapping(value={"/sys/schedule"})
@Api(value="\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f", tags={"\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f"})
public class SysScheduleJobController {
    private static final Logger log = LoggerFactory.getLogger(SysScheduleJobController.class);
    @Autowired
    private SysScheduleJobService sysScheduleJobService;

    @ApiOperation(value="\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1", notes="\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping
    public Result<SysScheduleJobDto> save(@Valid @RequestBody @ApiParam(value="\u5b9a\u65f6\u4efb\u52a1\u6dfb\u52a0dto", required=true) SysScheduleJobAddDto sysScheduleJobAddDto, BindingResult result) {
        ParamUtil.getErrorMsg((BindingResult)result);
        SysScheduleJobDto sysScheduleJobDto = this.sysScheduleJobService.save(sysScheduleJobAddDto);
        return Result.ok((Object)sysScheduleJobDto);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952eid\u6279\u91cf\u903b\u8f91\u5220\u9664\u5b9a\u65f6\u4efb\u52a1", notes="\u6839\u636e\u4e3b\u952eid\u6279\u91cf\u903b\u8f91\u5220\u9664\u5b9a\u65f6\u4efb\u52a1")
    @ApiImplicitParam(name="primaryIds", value="\u5b9a\u65f6\u4efb\u52a1ids", dataType="String", required=true)
    @DeleteMapping(value={"/batch/logic"})
    public Result<Integer> logicDelete(@RequestParam(value="primaryIds") String primaryIds) {
        Integer number = this.sysScheduleJobService.logicDelete(primaryIds);
        return Result.ok((Object)number);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952eid\u6279\u91cf\u76f4\u63a5\u5220\u9664\u5b9a\u65f6\u4efb\u52a1", notes="\u6839\u636e\u4e3b\u952eid\u6279\u91cf\u76f4\u63a5\u5220\u9664\u5b9a\u65f6\u4efb\u52a1")
    @ApiImplicitParam(name="primaryIds", value="\u5b9a\u65f6\u4efb\u52a1ids", dataType="String", required=true)
    @DeleteMapping(value={"/batch/direct"})
    public Result<Integer> directDelete(@RequestParam(value="primaryIds") String primaryIds) {
        Integer number = this.sysScheduleJobService.directDelete(primaryIds);
        return Result.ok((Object)number);
    }

    @ApiOperation(value="\u6839\u636eid\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1", notes="\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1")
    @PutMapping
    public Result<Integer> updateById(@Valid @RequestBody @ApiParam(value="\u5b9a\u65f6\u4efb\u52a1\u4fee\u6539dto", required=true) SysScheduleJobUpdateDto sysScheduleJobUpdateDto, BindingResult result) {
        ParamUtil.getErrorMsg((BindingResult)result);
        Integer sum = this.sysScheduleJobService.updateById(sysScheduleJobUpdateDto);
        return Result.ok((Object)sum);
    }

    @ApiOperation(value="\u6839\u636eids\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1", notes="\u6839\u636eids\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1")
    @ApiImplicitParam(name="primaryIds", value="\u5b9a\u65f6\u4efb\u52a1ids", dataType="String", required=true)
    @GetMapping(value={"/list"})
    public Result<List<SysScheduleJobDto>> findByPrimaryIds(@RequestParam(value="primaryIds") String primaryIds) {
        List<SysScheduleJobDto> list = this.sysScheduleJobService.findByPrimaryIds(primaryIds);
        return Result.ok(list);
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1", notes="\u6839\u636eid\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1")
    @ApiImplicitParam(name="primaryId", value="\u5b9a\u65f6\u4efb\u52a1\u7684id", dataType="Long", required=true, paramType="path")
    @GetMapping(value={"/primaryId"})
    public Result<SysScheduleJobDto> findByPrimaryId(@RequestParam(value="primaryId") Long primaryId) {
        SysScheduleJobDto result = this.sysScheduleJobService.findByPrimaryId(primaryId);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1", notes="\u5206\u9875\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1")
    @GetMapping(value={"/page"})
    public Result<IPage<SysScheduleJobDto>> findByPageHelper(@Valid @ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo) {
        return Result.ok(this.sysScheduleJobService.findByPageHelper(pageInfo));
    }

    @ApiOperation(value="\u7acb\u5373\u6267\u884c\u4efb\u52a1\u5b9a\u65f6\u4efb\u52a1", notes="\u7acb\u5373\u6267\u884c\u4efb\u52a1\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/run"})
    public Result<Boolean> run(@RequestParam(value="primaryIds") String primaryIds) {
        return Result.ok((Object)this.sysScheduleJobService.run(primaryIds));
    }

    @ApiOperation(value="\u6682\u505c\u5b9a\u65f6\u4efb\u52a1", notes="\u6682\u505c\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/pause"})
    public Result<Boolean> pause(@RequestParam(value="primaryIds") String primaryIds) {
        return Result.ok((Object)this.sysScheduleJobService.pause(primaryIds));
    }

    @ApiOperation(value="\u6062\u590d\u5b9a\u65f6\u4efb\u52a1", notes="\u6062\u590d\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/resume"})
    public Result<Boolean> resume(@RequestParam(value="primaryIds") String primaryIds) {
        return Result.ok((Object)this.sysScheduleJobService.resume(primaryIds));
    }

    @ApiOperation(value="\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1", notes="\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/stop"})
    public Result<Boolean> stop(@RequestParam(value="primaryIds") String primaryIds) {
        return Result.ok((Object)this.sysScheduleJobService.stop(primaryIds));
    }

    @ApiOperation(value="\u91cd\u542f\u6570\u636e\u5e93\u4e2d\u6240\u6709\u7684Job(\u5c06\u6570\u636e\u5e93\u4e2d\u6682\u505c\u4e0e\u505c\u6b62\u7684\u4efb\u52a1\u5168\u90e8\u91cd\u542f)", notes="\u91cd\u542f\u6570\u636e\u5e93\u4e2d\u6240\u6709\u7684Job(\u5c06\u6570\u636e\u5e93\u4e2d\u6682\u505c\u4e0e\u505c\u6b62\u7684\u4efb\u52a1\u5168\u90e8\u91cd\u542f)")
    @PostMapping(value={"/refresh/all"})
    public Result<Integer> refreshAll() {
        return Result.ok((Object)this.sysScheduleJobService.reStartAllJobs());
    }
}

