/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.quartz.listener;

import cn.hutool.core.date.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import top.doudou.base.convert.ConvertBeanUtils;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobDto;
import top.doudou.common.quartz.entity.dto.sysschedulejoblog.SysScheduleJobLogAddDto;
import top.doudou.common.quartz.event.ScheduleJobEvent;
import top.doudou.common.quartz.service.SysScheduleJobLogService;
import top.doudou.common.quartz.service.SysScheduleJobService;
import top.doudou.common.quartz.util.SpringBeanTaskUtil;

@Component
@EnableAsync
public class SysJobListener {
    private static final Logger log = LoggerFactory.getLogger(SysJobListener.class);
    private final SysScheduleJobLogService sysScheduleJobLogService;
    private final SysScheduleJobService sysScheduleJobService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @EventListener(value={ScheduleJobEvent.class})
    public void scheduleJobEventListener(ScheduleJobEvent event) {
        SysScheduleJobDto temp = event.getScheduleJob();
        SysScheduleJobDto scheduleJob = this.sysScheduleJobService.findByPrimaryId(temp.getId());
        SysScheduleJobLogAddDto jobLog = new SysScheduleJobLogAddDto();
        jobLog.setJobId(scheduleJob.getId());
        jobLog.setBean(scheduleJob.getBean());
        jobLog.setMethod(scheduleJob.getMethod());
        jobLog.setParams(scheduleJob.getParams());
        long startTime = SystemClock.now();
        StringBuilder sb = new StringBuilder();
        sb.append("\u4efb\u52a1\u51c6\u5907\u6267\u884c\uff0c\u4efb\u52a1ID\uff1a" + scheduleJob.getId()).append("  bean\uff1a" + scheduleJob.getBean()).append("  method\uff1a" + scheduleJob.getMethod());
        try {
            SpringBeanTaskUtil.invokeMethod((SysScheduleJobDto)ConvertBeanUtils.copyProperties((Object)scheduleJob, SysScheduleJobDto.class));
            jobLog.setStatus(1);
            sb.append("  \u6267\u884c\u6210\u529f");
        }
        catch (Exception e) {
            jobLog.setStatus(0);
            sb.append("  \u5931\u8d25\u7684\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            jobLog.setError(e.getMessage());
        }
        finally {
            long times = SystemClock.now() - startTime;
            jobLog.setTime((int)times);
            sb.append("  \u603b\u8017\u65f6\uff1a").append(times).append("\u6beb\u79d2");
            log.info(sb.toString());
            this.sysScheduleJobLogService.save(jobLog);
        }
    }

    public SysJobListener(SysScheduleJobLogService sysScheduleJobLogService, SysScheduleJobService sysScheduleJobService) {
        this.sysScheduleJobLogService = sysScheduleJobLogService;
        this.sysScheduleJobService = sysScheduleJobService;
    }
}

