/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.quartz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import top.doudou.base.builder.JsonBuilder;
import top.doudou.base.convert.ConvertBeanUtils;
import top.doudou.base.exception.CustomException;
import top.doudou.base.page.PageInfo;
import top.doudou.base.util.FastAssert;
import top.doudou.common.quartz.config.ScheduleManager;
import top.doudou.common.quartz.dao.SysScheduleJobDao;
import top.doudou.common.quartz.entity.SysScheduleJob;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobAddDto;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobDto;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobUpdateDto;
import top.doudou.common.quartz.enums.ScheduleStatus;
import top.doudou.common.quartz.service.SysScheduleJobService;
import top.doudou.common.tool.client.SuggestiveLanguage;
import top.doudou.common.tool.utils.IPageUtil;
import top.doudou.common.tool.utils.ListUtils;

@Service
public class SysScheduleJobServiceImpl
extends ServiceImpl<SysScheduleJobDao, SysScheduleJob>
implements SysScheduleJobService {
    private static final Logger log = LoggerFactory.getLogger(SysScheduleJobServiceImpl.class);
    @Autowired
    private ScheduleManager scheduleManager;

    @PostConstruct
    public void init() {
        log.info("----\u521d\u59cb\u5316\u5b9a\u65f6\u5668----");
        List list = this.list();
        log.info("----\u5b9a\u65f6\u5668\u7684\u4e2a\u6570\u4e3a\uff1a{}----", (Object)list.size());
        List<SysScheduleJobDto> result = this.convertJobList(list);
        result.forEach(item -> {
            CronTrigger trigger = this.scheduleManager.getCronTrigger((SysScheduleJobDto)item);
            if (trigger == null) {
                this.scheduleManager.createScheduleJob((SysScheduleJobDto)item);
            } else if (ScheduleStatus.NORMAL.getType().equals(item.getStatus())) {
                this.scheduleManager.resumeJob((SysScheduleJobDto)item);
            } else if (ScheduleStatus.PAUSE.getType().equals(item.getStatus())) {
                this.scheduleManager.pauseJob((SysScheduleJobDto)item);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SysScheduleJobDto save(SysScheduleJobAddDto sysScheduleJobAddDto) {
        this.checkBeanAndParams(null, sysScheduleJobAddDto.getBean(), sysScheduleJobAddDto.getParams());
        Integer status = sysScheduleJobAddDto.getStatus();
        if (null != status && status.equals(0)) {
            return this.saveAndStart(sysScheduleJobAddDto);
        }
        SysScheduleJob sysScheduleJob = (SysScheduleJob)ConvertBeanUtils.copyProperties((Object)sysScheduleJobAddDto, SysScheduleJob.class);
        sysScheduleJob.setParams(JsonBuilder.gson().toJson(sysScheduleJobAddDto.getParams()));
        ((SysScheduleJobDao)this.baseMapper).insert(sysScheduleJob);
        return (SysScheduleJobDto)ConvertBeanUtils.copyProperties((Object)sysScheduleJob, SysScheduleJobDto.class);
    }

    @Override
    public SysScheduleJobDto saveAndStart(SysScheduleJobAddDto scheduleJob) {
        this.checkBeanAndParams(null, scheduleJob.getBean(), scheduleJob.getParams());
        SysScheduleJob sysScheduleJob = (SysScheduleJob)ConvertBeanUtils.copyProperties((Object)scheduleJob, SysScheduleJob.class);
        sysScheduleJob.setParams(JsonBuilder.gson().toJson(scheduleJob.getParams()));
        ((SysScheduleJobDao)this.baseMapper).insert(sysScheduleJob);
        SysScheduleJobDto sysScheduleJobDto = (SysScheduleJobDto)ConvertBeanUtils.copyProperties((Object)sysScheduleJob, SysScheduleJobDto.class);
        sysScheduleJobDto.setParams(JsonBuilder.gson().toJson(scheduleJob.getParams()));
        this.scheduleManager.createScheduleJob(sysScheduleJobDto);
        return sysScheduleJobDto;
    }

    @Override
    public boolean batchSave(List<SysScheduleJobAddDto> list) {
        List temp = ListUtils.copyList(list, SysScheduleJob.class);
        return this.saveBatch(temp);
    }

    public void checkBeanAndParams(Long primaryId, String bean, Map<String, Object> params) {
        String json = this.toJson(params);
        SysScheduleJobDto sysScheduleJobDto = this.findByBeanNameAndParams(bean, json);
        if (null == sysScheduleJobDto) {
            return;
        }
        if (null != primaryId && primaryId.equals(sysScheduleJobDto.getId())) {
            return;
        }
        throw new CustomException("bean:{} params:{}  \u5df2\u7ecf\u5b58\u5728\u5b9a\u65f6\u4efb\u52a1", new Object[]{bean, params});
    }

    public SysScheduleJobDto findByBeanNameAndParams(String bean, String params) {
        if (StringUtils.isBlank((CharSequence)bean)) {
            return null;
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"bean", (Object)bean);
        if (StringUtils.isNotBlank((CharSequence)params)) {
            wrapper.eq((Object)"params", (Object)params);
        }
        wrapper.eq((Object)"del_flag", (Object)0);
        wrapper.last("limit 1");
        SysScheduleJob sysScheduleJob = (SysScheduleJob)((SysScheduleJobDao)this.baseMapper).selectOne((Wrapper)wrapper);
        SysScheduleJobDto sysScheduleJobDto = (SysScheduleJobDto)ConvertBeanUtils.copyProperties((Object)sysScheduleJob, SysScheduleJobDto.class);
        return sysScheduleJobDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer logicDelete(String primaryIds) {
        if (StringUtils.isBlank((CharSequence)primaryIds)) {
            return 0;
        }
        List listId = ListUtils.stringToList((String)primaryIds);
        UpdateWrapper wrapper = Wrappers.update();
        wrapper.in((Object)"id", (Collection)listId);
        SysScheduleJob sysScheduleJob = new SysScheduleJob();
        sysScheduleJob.setDelFlag(1);
        sysScheduleJob.setUpdateDate(new Date());
        this.findByPrimaryIds(primaryIds).forEach(item -> this.scheduleManager.deleteScheduleJob((SysScheduleJobDto)item));
        Integer update = ((SysScheduleJobDao)this.baseMapper).update(sysScheduleJob, (Wrapper)wrapper);
        return update;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer directDelete(String primaryIds) {
        if (StringUtils.isBlank((CharSequence)primaryIds)) {
            return 0;
        }
        List listId = ListUtils.stringToList((String)primaryIds);
        this.findByPrimaryIds(primaryIds).forEach(item -> this.scheduleManager.deleteScheduleJob((SysScheduleJobDto)item));
        return ((SysScheduleJobDao)this.baseMapper).deleteBatchIds(listId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer updateById(SysScheduleJobUpdateDto sysScheduleJobUpdateDto) {
        this.checkBeanAndParams(sysScheduleJobUpdateDto.getId(), sysScheduleJobUpdateDto.getBean(), sysScheduleJobUpdateDto.getParams());
        SysScheduleJob sysScheduleJob = (SysScheduleJob)((SysScheduleJobDao)this.baseMapper).selectById(sysScheduleJobUpdateDto.getId());
        if (null == sysScheduleJob) {
            log.info("\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u4e3b\u952e\u4e3a\uff1a{}", (Object)sysScheduleJobUpdateDto.getId());
            return null;
        }
        sysScheduleJob = (SysScheduleJob)ConvertBeanUtils.copyProperties((Object)sysScheduleJobUpdateDto, SysScheduleJob.class);
        SysScheduleJobDto sysScheduleJobDto = (SysScheduleJobDto)ConvertBeanUtils.copyProperties((Object)sysScheduleJobUpdateDto, SysScheduleJobDto.class);
        this.scheduleManager.updateScheduleJob(sysScheduleJobDto);
        return ((SysScheduleJobDao)this.baseMapper).updateById(sysScheduleJob);
    }

    @Override
    public List<SysScheduleJobDto> findByPrimaryIds(String primaryIds) {
        List listIds = ListUtils.stringToList((String)primaryIds);
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", (Collection)listIds);
        wrapper.eq((Object)"del_flag", (Object)0);
        List sysScheduleJobs = ((SysScheduleJobDao)this.baseMapper).selectList((Wrapper)wrapper);
        return this.convertJobList(sysScheduleJobs);
    }

    @Override
    public SysScheduleJobDto findByPrimaryId(Long primaryId) {
        FastAssert.notEmpty((Object)primaryId, (String)SuggestiveLanguage.notEmpty((String)"\u4e3b\u952e"));
        SysScheduleJob sysScheduleJob = (SysScheduleJob)((SysScheduleJobDao)this.baseMapper).selectById(primaryId);
        if (sysScheduleJob == null || sysScheduleJob.getDelFlag() != 0) {
            return null;
        }
        SysScheduleJobDto sysScheduleJobDto = (SysScheduleJobDto)ConvertBeanUtils.copyProperties((Object)sysScheduleJob, SysScheduleJobDto.class);
        return sysScheduleJobDto;
    }

    @Override
    public IPage<SysScheduleJobDto> findByPageHelper(PageInfo pageInfo) {
        Page page = new Page((long)pageInfo.getPageIndex().intValue(), (long)pageInfo.getPageSize().intValue());
        IPage<SysScheduleJob> result = ((SysScheduleJobDao)this.baseMapper).findByPageHelper(page);
        IPage list = IPageUtil.create(result, SysScheduleJobDto.class);
        return list;
    }

    @Override
    public boolean run(String primaryIds) {
        List<SysScheduleJobDto> list = this.findByPrimaryIds(primaryIds);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        list.forEach(item -> this.scheduleManager.run((SysScheduleJobDto)item));
        return true;
    }

    @Override
    public boolean pause(String primaryIds) {
        List<SysScheduleJobDto> list = this.findByPrimaryIds(primaryIds);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        list.forEach(item -> this.scheduleManager.pauseJob((SysScheduleJobDto)item));
        return true;
    }

    @Override
    public boolean resume(String primaryIds) {
        List<SysScheduleJobDto> list = this.findByPrimaryIds(primaryIds);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        list.forEach(item -> this.scheduleManager.resumeJob((SysScheduleJobDto)item));
        return true;
    }

    @Override
    public boolean stop(String primaryIds) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer reStartAllJobs() {
        AtomicInteger ai = new AtomicInteger(0);
        Logger logger = log;
        synchronized (logger) {
            List<SysScheduleJobDto> result = this.findEffectiveJob();
            log.info("----\u5b9a\u65f6\u5668\u7684\u4e2a\u6570\u4e3a\uff1a{}----", (Object)result.size());
            result.forEach(item -> {
                CronTrigger trigger = this.scheduleManager.getCronTrigger((SysScheduleJobDto)item);
                if (trigger == null) {
                    this.scheduleManager.createScheduleJob((SysScheduleJobDto)item);
                } else if (ScheduleStatus.NORMAL.getType().equals(item.getStatus())) {
                    log.info("\u4efb\u52a1 : {} , Because {} status is {}", new Object[]{item.getRemark(), item.getBean(), item.getStatus()});
                } else {
                    ai.incrementAndGet();
                    this.scheduleManager.resumeJob((SysScheduleJobDto)item);
                }
            });
        }
        return ai.get();
    }

    public List<SysScheduleJobDto> findEffectiveJob() {
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"del_flag", (Object)0);
        List sysScheduleJobs = ((SysScheduleJobDao)this.baseMapper).selectList((Wrapper)wrapper);
        return this.convertJobList(sysScheduleJobs);
    }

    private String toJson(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        return JsonBuilder.gson().toJson(map);
    }

    private List<SysScheduleJobDto> convertJobList(List<SysScheduleJob> list) {
        ArrayList result = Lists.newArrayList();
        list.forEach(item -> {
            SysScheduleJobDto sysScheduleJobDto = (SysScheduleJobDto)ConvertBeanUtils.copyProperties((Object)item, SysScheduleJobDto.class);
            result.add(sysScheduleJobDto);
        });
        return result;
    }
}

