/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.quartz.util;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import top.doudou.base.builder.JsonBuilder;
import top.doudou.base.convert.ConvertBeanUtils;
import top.doudou.base.exception.CustomException;
import top.doudou.common.quartz.entity.dto.sysschedulejob.SysScheduleJobDto;
import top.doudou.common.tool.context.SpringContextUtil;

public class SpringBeanTaskUtil {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanTaskUtil.class);

    public static void invokeMethod(SysScheduleJobDto scheduleJob) {
        Object target = SpringContextUtil.getBean((String)scheduleJob.getBean());
        try {
            Class<?> aClass = target.getClass();
            Map paramMap = ConvertBeanUtils.convert2Map((String)scheduleJob.getParams());
            if (MapUtils.isNotEmpty((Map)paramMap)) {
                Method[] methods;
                for (Method item : methods = aClass.getMethods()) {
                    Parameter[] parameters;
                    if (!item.getName().equals(scheduleJob.getMethod()) || (parameters = item.getParameters()).length != paramMap.size()) continue;
                    Object[] objs = new Object[parameters.length];
                    for (int i = 0; i < parameters.length; ++i) {
                        Object o = paramMap.get(parameters[i].getName());
                        objs[i] = SpringBeanTaskUtil.convert(o, parameters[i].getType());
                    }
                    ReflectionUtils.makeAccessible((Method)item);
                    item.invoke(target, objs);
                    return;
                }
            }
            Method method = aClass.getDeclaredMethod(scheduleJob.getMethod(), new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            log.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25,bean:{},method:{}\u5931\u8d25\u7684\u539f\u56e0\uff1a{}", new Object[]{scheduleJob.getBean(), scheduleJob.getMethod(), e.getMessage()});
            e.printStackTrace();
            throw new CustomException((Throwable)e);
        }
    }

    private static boolean typeConvert(Object obj, Class<?> target) {
        try {
            JsonBuilder.gson().fromJson(obj.toString(), target);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static <T> T convert(Object obj, Class<T> target) {
        if (null == target) {
            throw new CustomException("target must be not null");
        }
        try {
            if (null == obj) {
                log.info("obj:{} \u4e3anull", obj);
                return null;
            }
            if ("java.lang.String".equals(target.getName())) {
                return (T)obj;
            }
            return (T)JsonBuilder.gson().fromJson(obj.toString(), target);
        }
        catch (Exception e) {
            log.info("obj:{} \u4e0d\u80fd\u8f6c\u6362\u4e3a\uff1a{}", obj, target);
            return null;
        }
    }
}

