package top.doudou.common.redis.lock;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;
import top.doudou.core.exception.ExceptionUtils;

import java.util.concurrent.TimeUnit;

@Slf4j
public class UpdateLockTimeoutTask implements Runnable {
    
    private String uuid;
    private String key;
    private StringRedisTemplate stringRedisTemplate;
    
    public UpdateLockTimeoutTask(String uuid, StringRedisTemplate stringRedisTemplate, String key) {
        this.uuid = uuid;
        this.key = key;
        this.stringRedisTemplate = stringRedisTemplate;
    }
    
    @Override
    public void run() {
        // 将以uuid为Key，当前线程Id为Value的键值对保存到Redis中
        stringRedisTemplate.opsForValue().set(uuid, String.valueOf(Thread.currentThread().getId()));
        // 定期更新锁的过期时间
        while (true) {
            stringRedisTemplate.expire(key, 10, TimeUnit.SECONDS);
            try{
                // 每隔3秒执行一次
                Thread.sleep(10000);
            }catch (InterruptedException e){
                log.error(ExceptionUtils.toString(e));
            }
        }
    }
}