/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.util.StringUtils;
import top.doudou.common.redis.annotation.CLock;
import top.doudou.common.redis.lock.LockUtils;
import top.doudou.common.redis.mode.LockMode;
import top.doudou.core.util.ElExpression;

@Aspect
@Order(value=1)
public class RLockAop {
    @Autowired(required=false)
    private DataSourceTransactionManager transactionManager;

    @Around(value="@annotation(top.doudou.common.redis.annotation.CLock)")
    public Object rLockAop(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        CLock cLock = method.getAnnotation(CLock.class);
        String key = (String)ElExpression.parseExpression((String)cLock.key(), (Method)method, (Object[])joinPoint.getArgs(), String.class, null);
        try {
            Object result;
            if (cLock.lockMode() == LockMode.AUTO && !StringUtils.isEmpty((Object)key)) {
                LockUtils.lockSync(key);
            }
            Object object = result = joinPoint.proceed();
            return object;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            LockUtils.unlock();
        }
    }
}

