/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis.lock;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import top.doudou.common.redis.lock.RedisLock;
import top.doudou.common.redis.lock.ThreadUtils;
import top.doudou.common.redis.lock.UpdateLockTimeoutTask;
import top.doudou.core.random.RandomUtils;

@Configuration
public class RedisLockImpl
implements RedisLock {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private ThreadLocal<String> threadLocal = new ThreadLocal();
    private ThreadLocal<Integer> reentryCount = new ThreadLocal();

    @Override
    public boolean tryLock(String key, long timeout, TimeUnit unit) {
        Boolean isLocked = false;
        if (this.threadLocal.get() == null) {
            String uuid = RandomUtils.randomUUID((int)32);
            this.threadLocal.set(uuid);
            isLocked = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)uuid, timeout, unit);
            if (!isLocked.booleanValue()) {
                while (!(isLocked = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)uuid, timeout, unit)).booleanValue()) {
                }
            }
            new Thread(new UpdateLockTimeoutTask(uuid, this.stringRedisTemplate, key)).start();
        } else {
            isLocked = true;
        }
        if (isLocked.booleanValue()) {
            Integer count;
            Integer n = count = this.reentryCount.get() == null ? Integer.valueOf(0) : this.reentryCount.get();
            Integer n2 = count = Integer.valueOf(count + 1);
            this.reentryCount.set(n);
        }
        return isLocked;
    }

    @Override
    public void releaseLock(String key) {
        Integer count;
        String uuid = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (this.threadLocal.get().equals(uuid) && ((count = this.reentryCount.get()) == null || (count = Integer.valueOf(count - 1)) <= 0)) {
            this.stringRedisTemplate.delete((Object)key);
            String threadId = (String)this.stringRedisTemplate.opsForValue().get((Object)uuid);
            Thread updateLockTimeoutThread = ThreadUtils.getThreadByThreadId(threadId);
            if (updateLockTimeoutThread != null) {
                updateLockTimeoutThread.interrupt();
                this.stringRedisTemplate.delete((Object)uuid);
            }
        }
    }
}

