/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis.lock;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import top.doudou.core.exception.ExceptionUtils;

public class UpdateLockTimeoutTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UpdateLockTimeoutTask.class);
    private String uuid;
    private String key;
    private StringRedisTemplate stringRedisTemplate;

    public UpdateLockTimeoutTask(String uuid, StringRedisTemplate stringRedisTemplate, String key) {
        this.uuid = uuid;
        this.key = key;
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public void run() {
        this.stringRedisTemplate.opsForValue().set((Object)this.uuid, (Object)String.valueOf(Thread.currentThread().getId()));
        while (true) {
            this.stringRedisTemplate.expire((Object)this.key, 10L, TimeUnit.SECONDS);
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error(ExceptionUtils.toString((Exception)e));
                continue;
            }
            break;
        }
    }
}

