/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis.transaction;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import top.doudou.base.context.ApplicationContextUtils;
import top.doudou.common.redis.transaction.TransactionMode;
import top.doudou.common.redis.utils.TransactionThreadLocal;

public class TransactionUtils {
    private static final Logger log = LoggerFactory.getLogger(TransactionUtils.class);
    private static DataSourceTransactionManager transactionManager = (DataSourceTransactionManager)ApplicationContextUtils.getBean(DataSourceTransactionManager.class);

    public static boolean startTransaction(TransactionMode mode) {
        if (transactionManager != null) {
            log.debug("[Cluster-Lock] - \u624b\u52a8\u5f00\u542fSpring\u4e8b\u52a1....");
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            if (mode == TransactionMode.NEW) {
                transactionDefinition.setPropagationBehavior(3);
            } else if (mode == TransactionMode.NOT) {
                transactionDefinition.setPropagationBehavior(4);
            }
            TransactionStatus transaction = transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            TransactionThreadLocal.setTransactionStatusThreadLocal(transaction);
            return true;
        }
        return false;
    }

    public static boolean commit() {
        if (transactionManager != null) {
            TransactionStatus transaction = TransactionThreadLocal.getTransactionStatusThreadLocal();
            if (transaction == null) {
                return false;
            }
            log.debug("[Cluster-Lock] - \u63d0\u4ea4Spring\u4e8b\u52a1....");
            transactionManager.commit(transaction);
            TransactionThreadLocal.clear();
            return true;
        }
        return false;
    }

    public static boolean rollback() {
        if (transactionManager != null) {
            TransactionStatus transaction = TransactionThreadLocal.getTransactionStatusThreadLocal();
            if (transaction == null) {
                return false;
            }
            log.debug("[Cluster-Lock] - \u56de\u6edaSpring\u4e8b\u52a1....");
            transactionManager.rollback(transaction);
            TransactionThreadLocal.clear();
            return true;
        }
        return false;
    }
}

