/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import top.doudou.common.redis.RedisUtil;

@Scope(value="prototype")
public class RedisDataSourceTransaction {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;

    public TransactionStatus begin() {
        TransactionStatus transaction = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute());
        this.redisUtil.begin();
        return transaction;
    }

    public void commit(TransactionStatus transactionStatus) throws Exception {
        if (transactionStatus == null) {
            throw new Exception("transactionStatus is null");
        }
        this.dataSourceTransactionManager.commit(transactionStatus);
    }

    public void rollback(TransactionStatus transactionStatus) throws Exception {
        if (transactionStatus == null) {
            throw new Exception("transactionStatus is null");
        }
        this.dataSourceTransactionManager.rollback(transactionStatus);
        this.redisUtil.discard();
    }
}

