/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.CollectionUtils;
import top.doudou.core.builder.JsonBuilder;
import top.doudou.core.exception.CustomException;

public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    private RedisTemplate redisTemplate;

    @Autowired
    @Order
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void begin() {
        this.redisTemplate.setEnableTransactionSupport(true);
        this.redisTemplate.multi();
    }

    public void exec() {
        this.redisTemplate.exec();
    }

    public void discard() {
        this.redisTemplate.discard();
    }

    public boolean expire(String key, long time) {
        return this.expire(key, time, TimeUnit.SECONDS);
    }

    public boolean expire(String key, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, timeUnit);
            }
        }
        catch (Exception e) {
            log.error("redis\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
        return true;
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            log.error("\u5224\u65adredis\u7f13\u5b58\u662f\u5426\u5305\u542bkey:{}\u503c\u5f02\u5e38\uff01", (Object)key, (Object)e);
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public Set<String> scan(String matchKey) {
        return this.scanKey("*" + matchKey + "*");
    }

    public Set<String> scanFront(String matchKey) {
        return this.scanKey("*" + matchKey);
    }

    public Set<String> scanAfter(String matchKey) {
        return this.scanKey(matchKey + "*");
    }

    private Set<String> scanKey(String key) {
        Set keys = (Set)this.redisTemplate.execute(connection -> {
            HashSet<String> keysTmp = new HashSet<String>();
            Cursor cursor = connection.scan(ScanOptions.scanOptions().match(key).count(10L).build());
            while (cursor.hasNext()) {
                keysTmp.add(new String((byte[])cursor.next()));
            }
            return keysTmp;
        });
        return keys;
    }

    public List<String> findKeysForPage(String patternKey, int page, int size) {
        ScanOptions options = ScanOptions.scanOptions().match(patternKey).build();
        RedisConnectionFactory factory = this.redisTemplate.getConnectionFactory();
        RedisConnection rc = Objects.requireNonNull(factory).getConnection();
        Cursor cursor = rc.scan(options);
        ArrayList<String> result = new ArrayList<String>(size);
        int tmpIndex = 0;
        int fromIndex = page * size;
        int toIndex = page * size + size;
        while (cursor.hasNext()) {
            if (tmpIndex >= fromIndex && tmpIndex < toIndex) {
                result.add(new String((byte[])cursor.next()));
                ++tmpIndex;
                continue;
            }
            if (tmpIndex >= toIndex) break;
            ++tmpIndex;
            cursor.next();
        }
        try {
            RedisConnectionUtils.releaseConnection((RedisConnection)rc, (RedisConnectionFactory)factory);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Set keys(String key) {
        try {
            Set keys = this.redisTemplate.keys((Object)key);
            return keys;
        }
        catch (Exception e) {
            log.error("redis\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    public Object get(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public <T> T get(String key, Class<T> target) {
        try {
            if (null == key) {
                return null;
            }
            Object obj = this.redisTemplate.opsForValue().get((Object)key);
            Gson gson = JsonBuilder.gson();
            return (T)gson.fromJson(gson.toJson(obj), target);
        }
        catch (Exception e) {
            throw new CustomException("\u7c7b\u578b\u4f20\u5165\u9519\u8bef");
        }
    }

    public List<Object> multiGet(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Lists.newArrayList();
        }
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("redis\u7f13\u5b58\u8bbe\u7f6e\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        return this.set(key, value, time, TimeUnit.SECONDS);
    }

    public boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Boolean setIfAbsent(String key, Object value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value);
    }

    public Boolean setIfAbsent(String key, Object value, long expireTime) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value, expireTime, TimeUnit.SECONDS);
    }

    public Long incr(String key) {
        return this.incr(key, 1L);
    }

    public Long incr(String key, long delta) {
        if (delta < 0L) {
            throw new IllegalArgumentException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Long decr(String key) {
        return this.decr(key, 1L);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new IllegalArgumentException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public <HK, HV> Map<HK, HV> hmgetWill(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        return this.hmsetObject(key, map);
    }

    public <HK, HV> boolean hmsetObject(String key, Map<HK, HV> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6ehmsetObject\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u8bbehmset\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6ehset\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6ehset\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public <T> Set<T> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error("redisUtil\u8bbe\u7f6esGet\u5f02\u5e38", (Throwable)e);
            return new HashSet();
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            log.error("redisUtil.sHasKey\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            log.error("redisUtil.sSet\u5f02\u5e38", (Throwable)e);
            return 0L;
        }
    }

    public long sSet(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            log.error("redisUtil.sSet\u5f02\u5e38", (Throwable)e);
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            log.error("redisUtil.sGetSetSize\u5f02\u5e38", (Throwable)e);
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            log.error("redisUtil.setRemove\u5f02\u5e38", (Throwable)e);
            return 0L;
        }
    }

    public <T> List<T> randomMembers(String key, long count) {
        try {
            List list = this.redisTemplate.opsForSet().randomMembers((Object)key, count);
            return list;
        }
        catch (Exception e) {
            log.error("redisUtil.randomMembers\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public Boolean move(String key, String value, String destKey) {
        try {
            Boolean aBoolean = this.redisTemplate.opsForSet().move((Object)key, (Object)value, (Object)destKey);
            return aBoolean;
        }
        catch (Exception e) {
            log.error("redisUtil.move\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public <T> List<T> pop(String key, long l) {
        try {
            List pop = this.redisTemplate.opsForSet().pop((Object)key, l);
            return pop;
        }
        catch (Exception e) {
            log.error("redisUtil.pop\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public <T> Set<T> intersect(String key, Collection<T> list) {
        try {
            Set set = this.redisTemplate.opsForSet().intersect((Object)key, list);
            return set;
        }
        catch (Exception e) {
            log.error("redisUtil.intersect\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error("redisUtil.lGet\u5f02\u5e38", (Throwable)e);
            return new ArrayList<Object>();
        }
    }

    public <T> List<T> lGetTo(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error("redisUtil.lGet\u5f02\u5e38", (Throwable)e);
            return new ArrayList();
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.error("redisUtil.lGetListSize\u5f02\u5e38", (Throwable)e);
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            log.error("redisUtil.lGetIndex\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("redisUtil.lSet\u6dfb\u52a0\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public long rightPushAll(String key, Object ... values) {
        try {
            Long aLong = this.redisTemplate.opsForList().rightPushAll((Object)key, values);
            return aLong;
        }
        catch (Exception e) {
            log.error("redisUtil\u6dfb\u52a0\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return 0L;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("redisUtil\u6dfb\u52a0\u5e26\u8fc7\u671f\u65f6\u95f4\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("redisUtil.lSet\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("redisUtil.lSet\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            log.error("redisUtil.lUpdateIndex\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            return this.redisTemplate.opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            log.error("redisUtil.lRemove\u5f02\u5e38", (Throwable)e);
            return 0L;
        }
    }
}

